#module imports
from fielddisplay import fielddisplay

class timestepping:
	#properties
	def __init__(self):
		# {{{ Properties
		self.time_step       = 0
		self.final_time      = 0
		self.time_adapt      = 0
		self.cfl_coefficient = 0
		
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   timestepping parameters:"
		string="%s\n\n%s"%(string,fielddisplay(obj,"time_step","length of time steps [yrs]"))
		string="%s\n%s"%(string,fielddisplay(obj,"final_time","final time to stop the simulation [yrs]"))
		string="%s\n%s"%(string,fielddisplay(obj,"time_adapt","use cfl condition to define time step ? (0 or 1) "))
		string="%s\n%s"%(string,fielddisplay(obj,"cfl_coefficient","coefficient applied to cfl condition"))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#time between 2 time steps
		obj.time_step=1/2

		#final time
		obj.final_time=10*obj.time_step

		#time adaptation? 
		obj.time_adapt=0
		obj.cfl_coefficient=.5

		return obj
	#}}}
