#module imports
from fielddisplay import fielddisplay

class mesh:
	#properties
	def __init__(self):
		# {{{ Properties
		self.x                           = float('NaN');
		self.y                           = float('NaN');
		self.z                           = float('NaN');
		self.elements                    = float('NaN');
		self.dimension                   = 0;
		self.numberoflayers              = 0;
		self.numberofelements            = 0;
		self.numberofvertices            = 0;
		self.numberofedges               = 0;
		
		self.lat                         = float('NaN');
		self.long                        = float('NaN');
		self.hemisphere                  = float('NaN');

		self.elementonbed                = float('NaN');
		self.elementonsurface            = float('NaN');
		self.vertexonbed                 = float('NaN');
		self.vertexonsurface             = float('NaN');
		self.lowerelements               = float('NaN');
		self.lowervertex                 = float('NaN');
		self.upperelements               = float('NaN');
		self.uppervertex                 = float('NaN');
		self.vertexonboundary            = float('NaN');

		self.edges                       = float('NaN');
		self.segments                    = float('NaN');
		self.segmentmarkers              = float('NaN');
		self.vertexconnectivity          = float('NaN');
		self.elementconnectivity         = float('NaN');
		self.average_vertex_connectivity = 0;

		self.x2d                         = float('NaN');
		self.y2d                         = float('NaN');
		self.elements2d                  = float('NaN');
		self.numberofvertices2d          = 0;
		self.numberofelements2d          = 0;

		self.extractedvertices           = float('NaN');
		self.extractedelements           = float('NaN');

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display

		if obj.dimension==3:
			string="\n%s"%("      Elements and vertices of the original 2d mesh:")
			
			string="%s\n%s"%(string,fielddisplay(obj,"numberofelements2d","number of elements"))
			string="%s\n%s"%(string,fielddisplay(obj,"numberofvertices2d","number of vertices"))
			string="%s\n%s"%(string,fielddisplay(obj,"elements2d","index into (x,y,z), coordinates of the vertices"))
			string="%s\n%s"%(string,fielddisplay(obj,"x2d","vertices x coordinate"))
			string="%s\n%s"%(string,fielddisplay(obj,"y2d","vertices y coordinate"))

			string="%s\n%s" %(string,"Elements and vertices of the extruded 3d mesh:")
		else:
			string="\n%s"%("      Elements and vertices:")

		string="%s\n%s"%(string,fielddisplay(obj,"numberofelements","number of elements"))
		



		string="%s\n%s"%(string,fielddisplay(obj,"numberofvertices","number of vertices"))
		string="%s\n%s"%(string,fielddisplay(obj,"elements","index into (x,y,z), coordinates of the vertices"))
		string="%s\n%s"%(string,fielddisplay(obj,"x","vertices x coordinate"))
		string="%s\n%s"%(string,fielddisplay(obj,"y","vertices y coordinate"))
		string="%s\n%s"%(string,fielddisplay(obj,"z","vertices z coordinate"))
		string="%s\n%s"%(string,fielddisplay(obj,"edges","edges of the 2d mesh (vertex1 vertex2 element1 element2)"))
		string="%s\n%s"%(string,fielddisplay(obj,"numberofedges","number of edges of the 2d mesh"))

		string="%s%s"%(string,"\n      Properties:")
		
		string="%s\n%s"%(string,fielddisplay(obj,"dimension","mesh dimension (2d or 3d)"))
		string="%s\n%s"%(string,fielddisplay(obj,"numberoflayers","number of extrusion layers"))
		string="%s\n%s"%(string,fielddisplay(obj,"vertexonbed","lower vertices flags list"))
		string="%s\n%s"%(string,fielddisplay(obj,"elementonbed","lower elements flags list"))
		string="%s\n%s"%(string,fielddisplay(obj,"vertexonsurface","upper vertices flags list"))
		string="%s\n%s"%(string,fielddisplay(obj,"elementonsurface","upper elements flags list"))
		string="%s\n%s"%(string,fielddisplay(obj,"uppervertex","upper vertex list (NaN for vertex on the upper surface)"))
		string="%s\n%s"%(string,fielddisplay(obj,"upperelements","upper element list (NaN for element on the upper layer)"))
		string="%s\n%s"%(string,fielddisplay(obj,"lowervertex","lower vertex list (NaN for vertex on the lower surface)"))
		string="%s\n%s"%(string,fielddisplay(obj,"lowerelements","lower element list (NaN for element on the lower layer"))
		string="%s\n%s"%(string,fielddisplay(obj,"vertexonboundary","vertices on the boundary of the domain flag list"))
		
		string="%s\n%s"%(string,fielddisplay(obj,"segments","edges on domain boundary (vertex1 vertex2 element)"))
		string="%s\n%s"%(string,fielddisplay(obj,"segmentmarkers","number associated to each segment"))
		string="%s\n%s"%(string,fielddisplay(obj,"vertexconnectivity","list of vertices connected to vertex_i"))
		string="%s\n%s"%(string,fielddisplay(obj,"elementconnectivity","list of vertices connected to element_i"))
		string="%s\n%s"%(string,fielddisplay(obj,"average_vertex_connectivity","average number of vertices connected to one vertex"))

		string="%s%s"%(string,"\n      Extracted model:")

		string="%s\n%s"%(string,fielddisplay(obj,"extractedvertices","vertices extracted from the model"))
		string="%s\n%s"%(string,fielddisplay(obj,"extractedelements","elements extracted from the model"))

		string="%s%s"%(string,"\n      Projection:")
		string="%s\n%s"%(string,fielddisplay(obj,"lat","vertices latitude"))
		string="%s\n%s"%(string,fielddisplay(obj,"long","vertices longitude"))
		string="%s\n%s"%(string,fielddisplay(obj,"hemisphere","Indicate hemisphere ""n"" or ""s"" "))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#the connectivity is the avergaded number of nodes linked to a
		#given node through an edge. This connectivity is used to initially
		#allocate memory to the stiffness matrix. A value of 16 seems to
		#give a good memory/time ration. This value can be checked in
		#trunk/test/Miscellaneous/runme.m
		obj.average_vertex_connectivity=25

		return obj
	#}}}

