%ACENET class definition
%
%   Usage:
%      cluster=acenet();
%      cluster=acenet('np',3);
%      cluster=acenet('np',3,'login','username');

classdef acenet
    properties (SetAccess=public) 
		 % {{{1
		 name='glacdyn.ace-net.ca'
		 %name='placentia.ace-net.ca'
		 %name='brasdor.ace-net.ca'
		 login='klemorza';
		 np=10;
		 port=0;
		 queue='shortq';
		 time=10;
		 % codepath='/usr/local/issm-r11321/bin'; % this one is for issm on acenet global
		 codepath='/home/klemorza/issm/bin'; % this one is for issm on my acenet directory
		 executionpath='/home/klemorza/issm/execution';
		 %}}}
	 end
	 methods
		 function cluster=acenet(varargin) % {{{1
			 %use provided options to change fields
			 options=pairoptions(varargin{:});

			 %initialize cluster using user settings if provided
			 if (exist([cluster.name '_settings'])==2), eval([cluster.name '_settings']); end

			 %OK get other fields
			 cluster=AssignObjectFields(pairoptions(varargin{:}),cluster);
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function checkconsistency(cluster,md,solution,analyses) % {{{1

			 available_queues={'debug','shortq','longq'};
			 queue_requirements_time=[60*1 60*3 60*17];
			 queue_requirements_np=[32 128 256];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)
		 end
		 %}}}
		 function BuildQueueScript(cluster,md) % {{{1

			 %retrieve parameters 
			 modelname=md.miscellaneous.name; 
			 solution=md.private.solution;

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

          %write instructions for launching a job on the cluster
          % fprintf(fid,'#!/bin/sh\n');
			 fprintf(fid,'#!/bin/bash\n');
          %fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s 2> %s.errlog >%s.outlog ',...
          %         cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname,modelname,modelname);
			 fprintf(fid,'#$ -cwd\n');
          fprintf(fid,'#$ -N issm\n');
          %fprintf(fid,'#$ -l h_rt=%i\n',cluster.time);
          fprintf(fid,'#$ -l h_rt=10:0:0\n');
          %fprintf(fid,'#$ -l h_rt=1:0:0,test=true\n');
          fprintf(fid,'#$ -pe ompi* %i\n',cluster.np);
          fprintf(fid,'#$ -j y\n');
          fprintf(fid,'module purge\n');
          fprintf(fid,'module load gcc openmpi/gcc\n');
          fprintf(fid,'module load issm\n');
          fprintf(fid,'\n');
          %fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s',cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname);
          fprintf(fid,'mpiexec -np %i %s/issm.exe %s %s %s 2> %s.errlog >%s.outlog ',...
                   cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname,modelname,modelname);

          % fprintf(fid,'#PBS -l select=%i:ncpus=1\n',cluster.np);
			 % fprintf(fid,'#PBS -N %s\n',modelname);
			 % fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
			 % fprintf(fid,'#PBS -q %s\n',queue);
			 % fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 % fprintf(fid,'#PBS -e %s.errlog \n',modelname);
			 % fprintf(fid,'export PBS_O_WORKDIR=%s\n',cluster.executionpath);
			 % fprintf(fid,'cd $PBS_O_WORKDIR\n');
			 % fprintf(fid,'export OMP_NUM_THREADS=1\n');
			 % fprintf(fid,'ulimit -s unlimited\n');
			 % fprintf(fid,'ulimit -c 0\n');
			 % fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpiexec -np %i %s/issm.exe %s %s %s',cluster.np,cluster.codepath,EnumToString(solution),cluster.executionpath,modelname);

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function LaunchQueueJob(cluster,md,options)% {{{1
			  %retrieve parameters 
          modelname=md.miscellaneous.name;
          solution=md.private.solution;

			 %lauch command, to be executed via ssh
			 launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.private.runtimename ' && mkdir ' md.private.runtimename ...
			                ' && cd ' md.private.runtimename ' && mv ../' md.private.runtimename '.tar.gz ./ && tar -zxf ' md.private.runtimename '.tar.gz  && qsub ' modelname '.queue '];

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.private.runtimename '.tar.gz ' md.miscellaneous.name '.bin ' md.miscellaneous.name '.queue '  md.miscellaneous.name '.petsc '];
				if md.qmu.isdakota,
					compressstring=[compressstring md.miscellaneous.name '.qmu.in'];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				issmscpout(md.cluster.name,md.cluster.executionpath,md.cluster.login,md.cluster.port,{[md.private.runtimename '.tar.gz']});
				
				disp('launching solution sequence on remote cluster');
				issmssh(md.cluster.name,md.cluster.login,md.cluster.port,launchcommand);

			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end

		 end
		 %}}}
		 function Download(cluster,md)% {{{1

			%some check
			if isempty(md.private.runtimename),
				error('pfe Download error message: supply runtime name for results to be loaded!');
			end

			%Figure out the  directory where all the files are in: 
			directory=[cluster.executionpath '/' md.private.runtimename '/'];

			%What packages are we picking up from remote cluster
			packages={[md.miscellaneous.name '.outlog'],[md.miscellaneous.name '.errlog']};
			%packages={};
			if md.qmu.isdakota,
				packages{end+1}=[md.miscellaneous.name '.qmu.err'];
				packages{end+1}=[md.miscellaneous.name '.qmu.out'];
				if isfield(md.qmu.params,'tabular_graphics_data'),
					if md.qmu.params.tabular_graphics_data==true,
						packages{end+1}='dakota_tabular.dat'; 
					end
				end
			else
				packages{end+1}=[md.miscellaneous.name '.outbin'];
			end

			%copy files from cluster to present directory
			issmscpin(cluster.name, cluster.login, cluster.port, directory, packages);
		end %}}}
	end
end
