/*!\file Segment.h
 * \brief: header file for node object
 */

#ifndef _SEGMENT_H_
#define _SEGMENT_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
/*}}}*/

class Segment: public Object{

	public:
		int eid;
		IssmDouble x1;
		IssmDouble y1;
		IssmDouble x2;
		IssmDouble y2;

		/*Segment constructors, destructors {{{1*/
		Segment();
		Segment(int eid,IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2);
		~Segment();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
};

#endif  /* _SEGMENT_H_ */
