/*!\file:  ProcessArguments.cpp
 * \brief: process arguments
 */ 

#include <stdio.h>
#include <cstring>

#include "../shared/shared.h"
#include "../include/include.h"

void ProcessArguments(int* solution_type,char** pbinfilename,char** poutbinfilename,char** ppetscfilename,char** plockfilename,int argc,char **argv){

	char *modelname      = NULL;
	char *binfilename    = NULL;
	char *outbinfilename = NULL;
	char *petscfilename  = NULL;
	char *lockfilename   = NULL;

	if(argc<2)_error_("Usage error: no solution requested");
	*solution_type=StringToEnumx(argv[1]);
	if(argc<3)_error_("Usage error: missing model name");
	modelname=argv[3];
	binfilename    = (char*)xmalloc((strlen(modelname)+strlen(".bin")   +1)*sizeof(char)); sprintf(binfilename,   "%s%s",modelname,".bin");
	outbinfilename = (char*)xmalloc((strlen(modelname)+strlen(".outbin")+1)*sizeof(char)); sprintf(outbinfilename,"%s%s",modelname,".outbin");
	petscfilename  = (char*)xmalloc((strlen(modelname)+strlen(".petsc") +1)*sizeof(char)); sprintf(petscfilename, "%s%s",modelname,".petsc");
	lockfilename   = (char*)xmalloc((strlen(modelname)+strlen(".lock")  +1)*sizeof(char)); sprintf(lockfilename,  "%s%s",modelname,".lock");

	/*Clean up and assign output pointer*/
	*pbinfilename=binfilename;
	*poutbinfilename=outbinfilename;
	*ppetscfilename=petscfilename;
	*plockfilename=lockfilename;
}
