/*
 * UpdateElementsPrognostic:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsPrognostic(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    dim;
	int    numberofelements;
	int    stabilization;
	bool   dakota_analysis;
	bool   ispdd;

	/*Fetch data needed: */
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&numberofelements,MeshNumberofelementsEnum);
	iomodel->Constant(&stabilization,PrognosticStabilizationEnum);
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);
	iomodel->FetchData(1,MeshElementsEnum);
	iomodel->Constant(&ispdd,SurfaceforcingsIspddEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,BathymetryEnum);
	iomodel->FetchDataToInput(elements,MaskElementonfloatingiceEnum);
	iomodel->FetchDataToInput(elements,MaskElementonwaterEnum);
	iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateEnum);
	iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateCorrectionEnum);
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);

	if(stabilization==3){
		iomodel->FetchDataToInput(elements,PrognosticSpcthicknessEnum); //for DG, we need the spc in the element
	}

	if(dakota_analysis){
		elements->InputDuplicate(BedEnum,QmuBedEnum);
		elements->InputDuplicate(ThicknessEnum,QmuThicknessEnum);
		elements->InputDuplicate(SurfaceEnum,QmuSurfaceEnum);
	}

	if (dim==3){
		iomodel->FetchDataToInput(elements,MeshElementonbedEnum);
		iomodel->FetchDataToInput(elements,MeshElementonsurfaceEnum);
		iomodel->FetchDataToInput(elements,PressureEnum);
		iomodel->FetchDataToInput(elements,TemperatureEnum);
	}
	if(ispdd){
	  iomodel->FetchDataToInput(elements,VyEnum); 
	  iomodel->FetchDataToInput(elements,ThermalSpctemperatureEnum);
	  iomodel->FetchDataToInput(elements,SurfaceforcingsPrecipitationEnum);
	  iomodel->FetchDataToInput(elements,SurfaceforcingsMonthlytemperaturesEnum);
	}
	else{
		iomodel->FetchDataToInput(elements,SurfaceforcingsMassBalanceEnum);
	}

	/*Free data: */
	iomodel->DeleteData(1,MeshElementsEnum);
}
