/*! \file IntInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTINPUT_H_
#define _INTINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class IntInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmInt value;

		/*IntInput constructors, destructors: {{{1*/
		IntInput();
		IntInput(int enum_type,IssmInt value);
		~IntInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*IntInput management: {{{1*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(double* pvalue);
		void GetInputValue(double* pvalue,GaussTria* gauss);
		void GetInputValue(double* pvalue,GaussTria* gauss,double time){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss);
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetInputAverage(double* pvalue){_error_("not implemented yet");};
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum){_error_("not implemented yet");};
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		double InfinityNorm(void){_error_("InfinityNorm not implemented for integers");};
		double Max(void){_error_("Max not implemented for integers");};
		double MaxAbs(void){_error_("Max not implemented for integers");};
		double Min(void){_error_("Min not implemented for integers");};
		double MinAbs(void){_error_("Min not implemented for integers");};
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _INTINPUT_H */
