%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		precipitation = NaN;
		mass_balance  = NaN;
		ispdd = NaN;
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		  
		  %pdd methode not use in default mode
		  obj.ispdd=0;

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum,analyses),
				checkfield(md,'surfaceforcings.mass_balance','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum,analyses),
				checkfield(md,'surfaceforcings.mass_balance','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
			if (ismember(PrognosticAnalysisEnum,analyses) & md.surfaceforcings.ispdd),
			  checkfield(md,'surfaceforcings.ispdd','numel',1,'values',[0 1]);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			fielddisplay(obj,'precipitation','surface precipitation [m/yr water eq]');
			fielddisplay(obj,'mass_balance','surface mass balance [m/yr ice eq]');
			fielddisplay(obj,'ispdd','is pdd activated (0 or 1, default is 0)');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','precipitation','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','mass_balance','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ispdd','format','Boolean');

		end % }}}
	end
end
