/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;
	bool ispdd;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(PrognosticAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&ispdd,SurfaceforcingsIspddEnum);

	if(ispdd){
	  _printf_(VerboseSolution(),"   call positive degree day module\n");
	  PositiveDegreeDayx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}	

	_printf_(VerboseSolution(),"   call computational core\n");
	solver_linear(femmodel);
	
	if(save_results){
		_printf_(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}
}
