/*! \file OptionChar.h 
 *  \brief: header file for optionchar object
 */

#ifndef _OPTIONCHAR_H_
#define _OPTIONCHAR_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionChar: public Option {

	public:

		char* values;

		/*OptionChar constructors, destructors {{{1*/
		OptionChar();
		~OptionChar();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		int   ObjectEnum(){return OptionCharEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue){_error_("An OptionChar object cannot return a int");};
		void  Get(double* pvalue){_error_("An OptionChar object cannot return a double");};
		void  Get(bool* pvalue){  _error_("An OptionChar object cannot return a bool");};
		void  Get(char** pvalue);
		void  Get(char*** ppvalue,int *pnumel);
		void  Get(double** pvalue,int *pnumel){ _error_("An OptionChar object cannot return a double vec");};
		void  Get(Options** pvalue){ _error_("An OptionChar object cannot return an Options DataSet");};
		void  Get(Options*** ppvalue,int *pnumel){ _error_("An OptionChar object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONCHAR_H */

