/*! \file OptionCell.h 
 *  \brief: header file for optioncell object
 */

#ifndef _OPTIONCELL_H_
#define _OPTIONCELL_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionCell: public Option {

	public:

		Options* values;

		/*OptionCell constructors, destructors {{{1*/
		OptionCell();
		~OptionCell();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		int   ObjectEnum(){return OptionCellEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(int* pvalue){_error_("An OptionCell object cannot return a int");};
		void  Get(double* pvalue){_error_("An OptionCell object cannot return a double");};
		void  Get(bool* pvalue){  _error_("An OptionCell object cannot return a bool");};
		void  Get(char** pvalue){ _error_("An OptionCell object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error_("An OptionCell object cannot return a string vec");};
		void  Get(double** pvalue,int *pnumel){ _error_("An OptionCell object cannot return a double vec");};
		void  Get(Options** pvalue);
		void  Get(Options*** ppvalue,int *pnumel){ _error_("An OptionCell object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONCELL_H */

