/*! \file PowerVariogram.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _POWERVARIOGRAM_H_
#define _POWERVARIOGRAM_H_

/*Headers:*/
#include "./Variogram.h"

class PowerVariogram: public Variogram{

	public:
		double nugget; //The height of the jump of the semivariogram at the discontinuity at the origin
		double slope;  
		double power; 

		/*PowerVariogram constructors, destructors*/
		PowerVariogram();
		PowerVariogram(Options* options);
		~PowerVariogram();

		/*Object virtual functions definitions*/
		void  Echo();
		void  DeepEcho(){_error_("Not implemented yet");};
		int   Id(){_error_("Not implemented yet");}; 
		int   MyRank(){_error_("Not implemented yet");};
		int   ObjectEnum(){_error_("Not implemented yet");};
		Object* copy(){_error_("Not implemented yet");};

		/*Variogram functions*/
		double SemiVariogram(double deltax,double deltay);
		double Covariance(double deltax,double deltay);
};
#endif  /* _POWERVARIOGRAM_H */
