/*!\file:  Input.h
 * \brief abstract class for Input object
 */ 


#ifndef _INPUT_H_
#define _INPUT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class Node;
class ElementResult;
class GaussTria;
class Parameters;
/*}}}*/

class Input: public Object{

	public: 
		
		virtual        ~Input(){};
		/*Virtual functions:{{{1*/
		virtual int  InstanceEnum()=0; 
		virtual void GetInputValue(bool* pvalue)=0;
		virtual void GetInputValue(int* pvalue)=0;
		virtual void GetInputValue(double* pvalue)=0;
		virtual void GetInputValue(double* pvalue,GaussTria* gauss)=0;
		virtual void GetInputValue(double* pvalue,GaussPenta* gauss)=0;
		virtual void GetInputValue(double* pvalue,GaussTria* gauss ,int index)=0;
		virtual void GetInputValue(double* pvalue,GaussPenta* gauss,int index)=0;
		virtual void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss)=0;
		virtual void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetInputAverage(double* pvalue)=0;
		virtual void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss)=0;
		virtual void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss)=0;
		virtual void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss)=0;
		virtual void ChangeEnum(int newenumtype)=0;
		virtual void Configure(Parameters* parameters)=0;

		virtual void   SquareMin(double* psquaremin, bool process_units,Parameters* parameters)=0;
		virtual void   ConstrainMin(double minimum)=0;
		virtual double InfinityNorm(void)=0;
		virtual double MaxAbs(void)=0;
		virtual double MinAbs(void)=0;
		virtual double Max(void)=0;
		virtual double Min(void)=0;
		virtual void   Scale(double scale_factor)=0;
		virtual void   ArtificialNoise(double min,double max)=0;
		virtual void   AXPY(Input* xinput,double scalar)=0;
		virtual void   Constrain(double cm_min, double cm_max, double cm_thresh)=0;
		virtual void   VerticallyIntegrate(Input* thickness_input)=0;
		virtual void   Extrude()=0;
		virtual void   GetVectorFromInputs(Vector* vector,int* doflist)=0;
		virtual void   GetValuesPtr(double** pvalues,int* pnum_values)=0;
		
		virtual Input* SpawnTriaInput(int* indices)=0;
		virtual Input* PointwiseDivide(Input* inputB)=0;
		virtual Input* PointwiseMax(Input* inputmax)=0;
		virtual Input* PointwiseMin(Input* inputmin)=0;
		virtual Input* PointwiseThresh(Input* inputthresh,Input* inputmin)=0;
		virtual ElementResult* SpawnResult(int step, double time)=0;

		/*}}}*/

};
#endif
