/*!\file GaussianVariogram.c
 * \brief: implementation of the GaussianVariogram object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

/*GaussianVariogram constructors and destructor*/
/*FUNCTION GaussianVariogram::GaussianVariogram(){{{1*/
GaussianVariogram::GaussianVariogram(){
	this->nugget = 0.2;
	this->sill   = 1;
	this->range  = SQRT3;
	return;
}
/*}}}*/
/*FUNCTION GaussianVariogram::GaussianVariogram(Options* options){{{1*/
GaussianVariogram::GaussianVariogram(Options* options){

	/*Defaults*/
	this->nugget = 0.2;
	this->sill   = 1;
	this->range  = SQRT3;

	/*Overwrite from options*/
	if(options->GetOption("nugget")) options->Get(&this->nugget,"nugget");
	if(options->GetOption("sill"))   options->Get(&this->sill,"sill");
	if(options->GetOption("range"))  options->Get(&this->range,"range");

	/*Checks*/
	if(nugget==sill) _error_("nugget and sill cannot be equal (constant semivariogram not allowed)");
}
/*}}}*/
/*FUNCTION GaussianVariogram::~GaussianVariogram(){{{1*/
GaussianVariogram::~GaussianVariogram(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION GaussianVariogram::Echo {{{1*/
void GaussianVariogram::Echo(void){
	printf("GaussianVariogram\n");
	printf("   nugget: %g\n",this->nugget);
	printf("   sill  : %g\n",this->sill);
	printf("   range : %g\n",this->range);
}
/*}}}*/

/*Variogram function*/
/*FUNCTION GaussianVariogram::SemiVariogram{{{1*/
double GaussianVariogram::SemiVariogram(double deltax,double deltay){
	/*http://en.wikipedia.org/wiki/Variogram*/
	double h2,a,gamma;

	/*Calculate length square*/
	h2=pow(deltax,2.)+pow(deltay,2.);

	/*return semi-variogram*/
	a     = 1./3.;
	gamma = (sill-nugget)*(1.-exp(-h2/(a*range*range))) + nugget;
	return gamma;
}
/*}}}*/
