/*!\file:  ElementVector.h
 * \brief container for information needed to plug element vector generated by elements 
 * into the pf global load vector. 
 * This object will hold the element vector on the g-set, the local as well as global 
 * dof lists in the f set
 */ 

#ifndef _ELEMENT_VECTOR_H_
#define _ELEMENT_VECTOR_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
class Node;
/*}}}*/

class ElementVector{

	public:
	
		int      nrows;
		double*  values;
		
		//gset
		int*     gglobaldoflist;

		//fset
		int      fsize;
		int*     flocaldoflist;
		int*     fglobaldoflist;
		
		/*ElementVector constructors, destructors {{{1*/
		ElementVector();
		ElementVector(ElementVector* pe1,ElementVector* pe2);
		ElementVector(ElementVector* pe1,ElementVector* pe2,ElementVector* pe3);
		ElementVector(Node** nodes,int numnodes,Parameters* parameters,int approximation=NoneApproximationEnum);
		~ElementVector();
		/*}}}*/
		/*ElementVector specific routines {{{1*/
		void AddToGlobal(Vector* pf);
		void InsertIntoGlobal(Vector* pf);
		void Echo(void);
		void CheckConsistency(void);
		void Init(ElementVector* pe);
		void SetValue(double scalar);
		/*}}}*/
};
#endif //#ifndef _ELEMENT_VECTOR_H_

