#!/bin/bash

#Some cleanup
rm -rf install petsc-2.3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-2.3.2-p3.tar.gz' 'petsc-2.3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-2.3.2-p3.tar.gz
mv petsc-2.3.2-p3/* install/
rm -rf petsc-2.3.2-p3

#configure
cd install
./config/configure.py  \
	--with-parallel-no \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_ARCH=cygwin-intel \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/install" \
	--with-debugging=0 \
	--with-mpi=0 \
	--download-c-blas-lapack=1

#Compile petsc and install it
make
make install
