#!/bin/bash

#Some cleanup
rm -rf src install mpich2-1.0.2p1
mkdir src install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/mpich2-1.0.2p1.tar.gz' 'mpich2-1.0.2p1.tar.gz'

#Untar 
tar -zxvf  mpich2-1.0.2p1.tar.gz

#Move mpich2 into src directory
mv mpich2-1.0.2p1/* src
rm -rf mpich2-1.0.2p1

#Configure mpich2
cd src
make distclean
export CFLAGS="$CFLAGS -fPIC"
export FFLAGS="$FFLAGS -fPIC"
./configure --prefix="$ISSM_DIR/externalpackages/mpich2/install" 

#Apply Patch to examples
patch ./examples/Makefile ../configs/1.0.2/win32/Examples.Makefile.patch
patch -R ./src/binding/cxx/mpicxx.h ../configs/1.0.2/win32/mpicxx.h.patch
patch -R ./src/include/mpicxx.h ../configs/1.0.2/win32/mpicxx.h.patch

#Compile mpich2
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install 

#remove so files
cd ../install/lib
rm -rf *.so
