#!/bin/bash

#Some cleanup
rm -rf src
rm -rf install
rm -rf freetype-2.4.9
mkdir src install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/freetype-2.4.9.tar.gz' 'freetype-2.4.9.tar.gz'

#Untar 
tar -zxvf  freetype-2.4.9.tar.gz

#Move freetype into src directory
mv freetype-2.4.9/* src
rm -rf freetype-2.4.9

#Configure freetype
cd src
sudo ./configure 

#Compile and install freetype
if [ -z $1 ]; then
	sudo make
else
	sudo make -j $1
fi
sudo make install
