/*!\file:  Vector.h
 * \brief wrapper to vector objects. The goal is to control which API (PETSc,Scalpack, Plapack?) 
 * implements our underlying vector format.
 */ 

#ifndef _VECTOR_H_
#define _VECTOR_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#ifdef _HAVE_ADOLC_
#include "adolc.h"
#endif
		
/*}}}*/

class Vector{

	public:
	
		#ifdef _HAVE_PETSC_
			Vec vector; 
		#else
			SeqVec* vector;
		#endif
		#ifdef _HAVE_ADOLC_
			adouble* avector;
		#endif

		/*Vector constructors, destructors {{{1*/
		Vector();
		Vector(int M,bool fromlocalsize=false);
		Vector(double* serial_vec,int pM);
		#ifdef _HAVE_PETSC_
		Vector(Vec petsc_vec);
		#endif
		#if defined(_HAVE_GSL_) && !defined(_HAVE_PETSC_)
		Vector(SeqVec*  seq_vec);
		#endif
		~Vector();
		/*}}}*/
		/*Vector specific routines {{{1*/
		void Echo(void);
		void    AXPY(Vector *X, double a);
		void    AYPX(Vector *X, double a);
		void    Assemble(void);
		void    Copy(Vector *to);
		double  Dot(Vector *vector);
		Vector *Duplicate(void);
		void    GetValue(double *pvalue, int dof);
		void    GetSize(int *pM);
		void    GetLocalSize(int *pM);
		bool    IsEmpty(void);
		double  Norm(NormMode norm_type);
		void    PointwiseDivide(Vector  *x,Vector*y);
		void    Scale(double scale_factor);
		void    Set(double value);
		void    SetValues(int ssize, int *list, double*values, InsMode mode);
		void    SetValue(int dof, double value, InsMode mode);
		double *ToMPISerial(void);
		/*}}}*/
};


#endif //#ifndef _VECTOR_H_
