#!/bin/bash
#Step 1: unzip and install
#Step 2: After Plapack implodes
STEP=0

if [ $STEP -eq 1 ]; then
	#Some cleanup
	rm -rf install petsc-2.3.2-p3 src
	mkdir install src

	#Download from ISSM server
	$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-2.3.2-p3.tar.gz' 'petsc-2.3.2-p3.tar.gz'

	#Untar and move petsc to install directory
	tar -zxvf  petsc-2.3.2-p3.tar.gz
	mv petsc-2.3.2-p3/* install/
	rm -rf petsc-2.3.2-p3

	#configure
	cd install
	./config/configure.py  \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH=$ISSM_ARCH \
		--PETSC_DIR=$PETSC_DIR   \
		--with-debugging=no \
		--with-shared=0 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--with-mpi-lib=/nasa/sgi/mpt/1.23.nas/lib64/libmpi.so \
		--with-mpi-include=/nasa/sgi/mpt/1.23.nas/include  \
		--with-mpi-shared=0 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-plapack=yes \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort \
		--COPTFLAGS=" -O3 -xS" \
		--FOPTFLAGS=" -O3 -xS" \
		--CXXOPTFLAGS=" -O3 -xS"

	echo "== Fix Plapack compilation manually (http://issm.jpl.nasa.gov/installation/compilationtroubleshooting/petsc232/) =="
	echo "== Then run STEP=2 =="
fi
if [ $STEP -eq 2 ]; then
	cd install
	./config/configure.py  \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH=$ISSM_ARCH \
		--PETSC_DIR=$PETSC_DIR   \
		--with-debugging=no \
		--with-shared=0 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--with-mpi-lib=/nasa/sgi/mpt/1.23.nas/lib64/libmpi.so \
		--with-mpi-include=/nasa/sgi/mpt/1.23.nas/include  \
		--with-mpi-shared=0 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--with-plapack-dir=$PETSC_DIR/externalpackages/PLAPACKR32-hg/$ISSM_ARCH \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort \
		--COPTFLAGS=" -O3 -xS" \
		--FOPTFLAGS=" -O3 -xS" \
		--CXXOPTFLAGS=" -O3 -xS"
	echo "== Follow PETSc's instructions"
fi
