#!/bin/bash

#Some cleanup
rm -rf install netcdf-4.0.1
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/netcdf-4.0.1.tar.gz' 'netcdf-4.0.1.tar.gz'

#Untar 
tar -zxvf  netcdf-4.0.1.tar.gz

#Move netcdf to install directory
rm -rf install/*
mv netcdf-4.0.1/* install/
rm -rf netcdf-4.0.1

#Configure and compile
cd install
./configure  --prefix="$ISSM_DIR/externalpackages/netcdf/install" 
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
