function md=geography2(md,landname,iceshelfname,icesheetname)

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

%recover elements and grids on land.
[gridonland,elementonland]=ContourToMesh(elements,x,y,expread(landname,1),'element and node',2);

%any element with 3 grids on land should be on land:
elementsonwater=find(~elementonland);
wrongelements=elementsonwater(find(( gridonland(md.elements(elementsonwater,1)) + gridonland(md.elements(elementsonwater,2)) + gridonland(md.elements(elementsonwater,3)) ...
                  )==3));
elementonland(wrongelements)=1;

%any element with its barycentre on land should be on land:
weights={[1;1;1],[2;1;1],[1;2;1],[1;1;2]};
for i=1:length(weights),
	xelem=x(md.elements)*weights{i}/sum(weights{i});
	yelem=y(md.elements)*weights{i}/sum(weights{i});
end
baryonland=ContourToNodes(xelem,yelem,expread(landname,1),1);
pos=find(~baryonland); elementonland(pos)=0;
pos=find(baryonland); elementonland(pos)=1;

%figure out which elements on land are actually in the middle of the ocean!
pos1=find(elementonland); 
connectedtoland=md.elementconnectivity(pos1,:);
pos=find(connectedtoland); connectedtoland(pos)=1-elementonland(connectedtoland(pos));
connectedtolandsum=sum(connectedtoland,2);
waterelements=pos1(find(connectedtolandsum==3));
elementonland(waterelements)=0;

%figure out which elements on water  are actually in the middle of the land!
pos1=find(~elementonland); 
connectedtowater=md.elementconnectivity(pos1,:);
pos=find(connectedtowater); connectedtowater(pos)=elementonland(connectedtowater(pos));
connectedtowatersum=sum(connectedtowater,2);
landelements=pos1(find(connectedtowatersum==3));
elementonland(landelements)=1;

%recover arrays of ice shelf grids and elements, and ice sheet grids and elements.
if strcmp(iceshelfname,''), %no iceshelf contour file, we are dealing with a pure ice sheet.
	gridoniceshelf=zeros(md.numberofgrids,1);
	elementoniceshelf=zeros(md.numberofelements,1);
elseif strcmp(iceshelfname,'all'), %we are dealing with a pure ice shelf.
	gridoniceshelf=ones(md.numberofgrids,1);
	elementoniceshelf=ones(md.numberofelements,1);
else
	[gridoniceshelf,elementoniceshelf]=ContourToMesh(elements,x,y,expread(iceshelfname,1),'element and node',2);
end

if strcmp(icesheetname,''), %no icesheet contour file, we are dealing with a pure ice shelf.
	gridonicesheet=zeros(md.numberofgrids,1);
	elementonicesheet=zeros(md.numberofelements,1);
else
	[gridonicesheet,elementonicesheet]=ContourToMesh(elements,x,y,expread(icesheetname,1),'element and node',2);
end


%now correct, so that none of the iceshelf and icesheet elements and nodes are in the water.
pos=find(~elementonland);
elementoniceshelf(pos)=0; 
elementonicesheet(pos)=0;

pos=find(~gridonland);
gridoniceshelf(pos)=0; 
gridonicesheet(pos)=0;

%create gridonwater and elementonwater: 
gridonwater=double(~gridonland);
elementonwater=double(~elementonland);


%correct for islands:
gridoniceshelf=double(gridoniceshelf & ~gridonicesheet);
elementoniceshelf=double(elementoniceshelf & ~elementonicesheet);

%now, icesheets are everything except iceshelves and water
gridonicesheet=double(~gridoniceshelf & ~gridonwater);
elementonicesheet=double(~elementoniceshelf & ~elementonwater);



%Deal with segments on neumann: 
elementconnectivity=md.elementconnectivity;
pos=find(elementconnectivity);
elementconnectivity(pos)=elementonwater(elementconnectivity(pos));

pos=find(elementonwater);
elementconnectivity(pos,:)=0;

num_segments=sum(sum(elementconnectivity));
segments=zeros(num_segments,3);

icefrontelementsonland=find(sum(elementconnectivity,2));

count=1;
for i=1:numel(icefrontelementsonland),
	el1=icefrontelementsonland(i);
	els2=md.elementconnectivity(el1,find(elementconnectivity(el1,:)));
	for j=1:numel(els2),
		el2=els2(j);
		%we have a segment between land el1 and water el2:
		segments(count,:)=[intersect(md.elements(el1,:),md.elements(el2,:)) el1];
		
		ord1=find(segments(count,1)==md.elements(el1,:));
		ord2=find(segments(count,2)==md.elements(el1,:));

		%swap segment grids if necessary
		if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
			temp=segments(count,1);
			segments(count,1)=segments(count,2);
			segments(count,2)=temp;
		end
		segments(count,1:2)=fliplr(segments(count,1:2));
		
		count=count+1;
	end
end

%Return: 
md.gridoniceshelf=gridoniceshelf;
md.elementoniceshelf=elementoniceshelf;

md.gridonwater=gridonwater;
md.elementonwater=elementonwater;

md.gridonicesheet=gridonicesheet;
md.elementonicesheet=elementonicesheet;

md.segmentonneumann_diag=segments;
md.counter=2;
md.segmentmarkers(:)=1;
