/*
 * \file Observations.c
 * \brief: implementation of the Observations class, derived from DataSet class
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "./Observations.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Observations::Observations(){{{*/
Observations::Observations(){
	this->quadtree = NULL;
	return;
}
/*}}}*/
/*FUNCTION Observations::Observations(double* observations_list,double* x,double* y,int n){{{*/
Observations::Observations(double* observations_list,double* x,double* y,int n){

	/*Intermediaries*/
	int          i;
	int          xi,yi;
	double       xmin,xmax,ymin,ymax;
	double       offset;
	Observation *observation = NULL;

	/*Get extrema*/
	xmin=x[0]; ymin=y[0];
	xmax=x[0]; ymax=y[0];
	for(i=1;i<n;i++){
		xmin=min(xmin,x[i]); ymin=min(ymin,y[i]);
		xmax=max(xmax,x[i]); ymax=max(ymax,y[i]);
	}
	offset=0.05*(xmax-xmin); xmin-=offset; xmax+=offset;
	offset=0.05*(ymax-ymin); ymin-=offset; ymax+=offset;

	/*Initialize Quadtree*/
	this->quadtree = new Quadtree(xmin,xmax,ymin,ymax,30);

	/*Add observations one by one*/
	for(i=0;i<n;i++){
		this->quadtree->IntergerCoordinates(&xi,&yi,x[i],y[i]);
		observation = new Observation(x[i],y[i],xi,yi,observations_list[i]);
		this->quadtree->Add(observation);
		this->AddObject(observation);
	}
}
/*}}}*/
/*FUNCTION Observations::~Observations(){{{*/
Observations::~Observations(){
	delete quadtree;
	return;
}
/*}}}*/

/*Methods*/
/*FUNCTION Observations::ObservationList{{{*/
void Observations::ObservationList(double **px,double **py,double **pobs,int* pnobs,double x_interp,double y_interp){

	/*Output and Intermediaries*/
	int          nobs,i;
	double      *x           = NULL;
	double      *y           = NULL;
	double      *obs         = NULL;
	Observation *observation = NULL;

	/*Get number of observations*/
	nobs = this->Size();

	/*Allocate vectors*/
	x   = (double*)xmalloc(nobs*sizeof(double));
	y   = (double*)xmalloc(nobs*sizeof(double));
	obs = (double*)xmalloc(nobs*sizeof(double));

	/*Loop over all observations and fill in x, y and obs*/
	for (i=0;i<nobs;i++){
		observation=(Observation*)this->GetObjectByOffset(i);
		observation->WriteXYObs(&x[i],&y[i],&obs[i]);
	}

	/*Assign output pointer*/
	*px=x;
	*py=y;
	*pobs=obs;
	*pnobs=nobs;
}/*}}}*/
/*FUNCTION Observations::QuadtreeColoring{{{*/
void Observations::QuadtreeColoring(double* A,double *x,double *y,int n){

	int xi,yi;

	for(int i=0;i<n;i++){
		this->quadtree->IntergerCoordinates(&xi,&yi,x[i],y[i]);
		this->quadtree->QuadtreeColoring(&A[i],xi,yi);
	}

}/*}}}*/
