
#ifndef _QUADTREEK_H
#define _QUADTREEK_H

class Observation;

class Quadtree{

	private:
		/* A quadtree box contains up to 4 points (locations). 4 new quadtree boxes are
		 * created if a fifth point is added to the same box. A Quadtree box is therefore
		 * composed of EITHER:
		 * - up to 4 vertices
		 * - 4 "sub" quadtree boxes*/

		class QuadtreeBox: public Object{ 
			public:
				int nbitems; // number of current vertices in the box
				union{
					QuadtreeBox *box[4];
					Observation *obs[4];
				};

				/*Object functions (Needed because the Quadtree uses a Container*/
				void    Echo()      {_error_("not implemented yet"); };
				void    DeepEcho()  {_error_("not implemented yet"); };
				int     Id()        {_error_("not implemented yet"); };
				int     MyRank()    {_error_("not implemented yet"); };
				int     ObjectEnum(){_error_("not implemented yet"); };
				Object *copy()      {_error_("not implemented yet"); };
		};

		/*Quadtree private Fields*/
		DataSet* boxcontainer;

	public:
		QuadtreeBox* root;          // main box
		long         NbQuadtreeBox; // total number of boxes
		long         NbObs;      // number of points

		Quadtree();
		~Quadtree();
		void         Echo(void);
		void         Add(Observation *observation);
		void         QuadtreeColoring(double *A,int *xi,int *yi,int n);
		QuadtreeBox *NewQuadtreeBox(void);
};
#endif //_QUADTREEK_H
