#!/bin/sh

./configure \
 --prefix=$ISSM_DIR \
 --with-matlab-dir=$MATLAB_DIR \
 --with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
 --with-metis-dir=$ISSM_DIR/externalpackages/metis/install \
 --with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-mpi-include=$ISSM_DIR/externalpackages/mpich2/install/include  \
 --with-mpi-lib="-L$ISSM_DIR/externalpackages/mpich2/install/lib/ -lmpich -lmpl -ldl" \
 --with-petsc-arch=$ISSM_ARCH \
 --with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-plapack-lib="-L$ISSM_DIR/externalpackages/petsc/install/ -lPLAPACK" \
 --with-plapack-include="-I$ISSM_DIR/externalpackages/petsc/install/externalpackages/PLAPACKR32-hg/INCLUDE" \
 --with-blacs-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-scotch-dir="$ISSM_DIR/externalpackages/scotch/install" \
 --with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
 --with-cxxoptflags="-mtune=barcelona -ffast-math -O3 -msse4.2 -Wno-write-strings "\
 --with-fortran-lib="-lgfortran"\
 --with-numthreads=8 \
 --with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
 --enable-debugging
 
 
