/*
 * \file Observations.c
 * \brief: implementation of the Observations class, derived from DataSet class
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "./Observations.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Observations::Observations(){{{*/
Observations::Observations(){
	return;
}
/*}}}*/
/*FUNCTION Observations::Observations(double* observations_list,double* x,double* y,int n){{{*/
Observations::Observations(double* observations_list,double* x,double* y,int n){

	/*Add observations one by one*/
	for(int i=0;i<n;i++){
		this->AddObject(new Observation(x[i],y[i],0,0,observations_list[i]));
	}

}
/*}}}*/
/*FUNCTION Observations::~Observations(){{{*/
Observations::~Observations(){
	return;
}
/*}}}*/

/*Methods*/
/*FUNCTION Observations::ObservationList{{{*/
void Observations::ObservationList(double **px,double **py,double **pobs,int* pnobs,double x_interp,double y_interp){/*{{{*/

	/*Output and Intermediaries*/
	int          nobs,i;
	double      *x           = NULL;
	double      *y           = NULL;
	double      *obs         = NULL;
	Observation *observation = NULL;

	/*Get number of observations*/
	nobs = this->Size();

	/*Allocate vectors*/
	x   = (double*)xmalloc(nobs*sizeof(double));
	y   = (double*)xmalloc(nobs*sizeof(double));
	obs = (double*)xmalloc(nobs*sizeof(double));

	/*Loop over all observations and fill in x, y and obs*/
	for (i=0;i<nobs;i++){
		observation=(Observation*)this->GetObjectByOffset(i);
		observation->WriteXYObs(&x[i],&y[i],&obs[i]);
	}

	/*Assign output pointer*/
	*px=x;
	*py=y;
	*pobs=obs;
	*pnobs=nobs;
}/*}}}*/
