#include "../objects.h"
/*DOCUMENTATION What is a Quadtree? {{{1
 * A Quadtree is a very simple way to group vertices according
 * to their locations. A square that holds all the points of the mesh
 * (or the geometry) is divided into 4 boxes. As soon as one box
 * hold more than 4 vertices, it is divided into 4 new boxes, etc...
 * There cannot be more than MAXDEEP (=30) subdivision.
 * This process is like a Dichotomy in dimension 2
 *
 *  + - -  -    - -    -    - - + -   - + - + - + - -     - - +
 *  |                           |       |   | X |             |
 *                                      + - + - +
 *  |                           |       |   |   |             |
 *                              + -   - + - + - +             +
 *  |                           |       |       |             |
 *                         
 *  |                           |       |       |             |
 *  + - -  -    - -    -    - - + -   - + -   - + - -     - - +
 *  |                           |               |             |
 *                         
 *  |                           |               |             |
 *                         
 *  |                           |               |             |
 *  |                           |               |             |
 *  + - -  -    - -    -    - - + -   -   -   - + - -     - - +
 *  |                           |                             |
 *                         
 *  |                           |                             |
 *                         
 *  |                           |                             |
 *                         
 *  |                           |                             |
 *  |                           |                             |
 *  |                           |                             |
 *  |                           |                             |
 *  |                           |                             |
 *  + - -  -    - -    -    - - + -   -   -   -   - -     - - +
 *
 * The coordinate system used in a quadtree are integers to avoid
 * round-off errors. The vertex in the lower left box has the coordinates
 * (0 0) 
 * The upper right vertex has the follwing coordinates:
 * 2^30 -1           2^30 -1        in decimal
 * 0 1 1 1 .... 1    0 1 1 1 .... 1 in binary
 *  \--   29  --/     \--   29  --/
 * Using binaries is therefore very easy to locate a vertex in a box:
 * we just need to look at the bits from the left to the right (See ::Add)
 }}}1*/

	/*Constructors/Destructors*/
	/*FUNCTION Quadtree::Quadtree(){{{1*/
	Quadtree::Quadtree(){

		/*Number of boxes and vertices*/
		NbQuadtreeBox=0;
		NbPoints=0;

		/*Create container*/
		boxcontainer=new DataSet();

		/*Create Root, pointer toward the main box*/
		root=NewQuadtreeBox();

		}
	/*}}}1*/
	/*FUNCTION Quadtree::~Quadtree(){{{1*/
	Quadtree::~Quadtree() {

		delete boxcontainer;
		root=NULL;

	}
	/*}}}1*/

	/*Methods*/
	/*FUNCTION Quadtree::NewQuadtreeBox {{{1*/
	Quadtree::QuadtreeBox* Quadtree::NewQuadtreeBox(void){

		/*Output*/
		QuadtreeBox* newbox=NULL;

		/*Create and initialize a new box*/
		newbox=new QuadtreeBox();
		newbox->nbitems=0;
		newbox->box[0]=NULL;
		newbox->box[1]=NULL;
		newbox->box[2]=NULL;
		newbox->box[3]=NULL;

		/*Add root to the container*/
		boxcontainer->AddObject(newbox);

		/*Increase counter*/
		NbQuadtreeBox++;

		/*currentbox now points toward next quadtree box*/
		return newbox;
	}/*}}}*/
