#!/bin/bash

#Some cleanup
rm -rf install slepc-2.3.2
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/slepc-2.3.2.tgz' 'slepc-2.3.2.tgz'

#Untar 
tar -zxvf  slepc-2.3.2.tgz

#Move slepc to install directory
mv slepc-2.3.2/* install/
rm -rf slepc-2.3.2

#Make slepc
cd install
./config/configure.py
if [ -z $1 ]; then
	make
else
	make -j $1
fi
