#!/bin/bash

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.1-p7.tar.gz' 'petsc-3.1-p7.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-mpi-dir=$ISSM_DIR/externalpackages/mpich2/install \
	--PETSC_ARCH=macosx-gnu \
	--with-fc=/usr/local/bin/gfortran \
	--with-debugging=0 \
	--with-shared=0 \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-plapack=yes  \
	--download-parmetis=yes \
	--download-f-blas-lapack=yes \
	--COPTFLAGS="-march=opteron -O2 " \
	--FOPTFLAGS="-march=opteron -O2 " \
	--CXXOPTFLAGS="-march=opteron -O2 " \
	--FFLAGS="-I$ISSM_DIR/externalpackages/mpich2/install/include -L$ISSM_DIR/externalpackages/mpich2/install/lib -L/usr/local/bin -lmpich -lpmpich -lgfortran " 

#Compile petsc and install it
make
make install
