#!/bin/bash

#Some cleanup
rm -rf install petsc-2.3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-2.3.2-p3.tar.gz' 'petsc-2.3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-2.3.2-p3.tar.gz
mv petsc-2.3.2-p3/* install/
rm -rf petsc-2.3.2-p3

#configure
cd install
PETSC_DIR=$ISSM_DIR/externalpackages/petsc/install
./config/configure.py  \
	--prefix=$PETSC_DIR \
	--with-batch=1  \
	--ISSM_ARCH=$ISSM_ARCH \
	--PETSC_DIR=$PETSC_DIR   \
	--with-debugging=no COPTFLAGS=-O3 FOPTFLAGS=-O3 \
	--with-blas-lapack-dir=/opt/intel/mkl/10.0.5.025/ \
	--with-mpi-dir=/opt/mpich/gm/intel10.1/  \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes  \
	--download-plapack=yes \
	--FFLAGS=-I/usr/include  \
	--with-mpi-shared=0

#Compile petsc and install it
make
make install
