#!/bin/bash

#Some cleanup
rm -rf install src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/graphviz-2.24.0.tar.gz' 'graphviz-2.24.0.tar.gz'

#Untar 
tar -zxvf  graphviz-2.24.0.tar.gz

#Move Dakota to src directory
mv graphviz-2.24.0/* src/
rm -rf graphviz-2.24.0

#Configure dakota
cd src
./configure --prefix="$ISSM_DIR/externalpackages/graphviz/install"
cd ..

#Compile and install
cd src
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
cd ..
