/*!\file SpcDynamic.c
 * \brief: implementation of the SpcDynamic object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"
#include "../objects.h"

/*SpcDynamic constructors and destructor*/
/*FUNCTION SpcDynamic::SpcDynamic(){{{1*/
SpcDynamic::SpcDynamic(){
	return;
}
/*}}}1*/
/*FUNCTION SpcDynamic::SpcDynamic(int spc_sid,int spc_nodeid,...){{{1*/
SpcDynamic::SpcDynamic(int spc_sid,int spc_nodeid, int spc_dof,int spc_analysis_type){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=0;
	analysis_type=spc_analysis_type;
	isset=false;

	return;
}
/*}}}1*/
/*FUNCTION SpcDynamic::~SpcDynamic{{{1*/
SpcDynamic::~SpcDynamic(){
	return;
}
/*}}}1*/
		
/*Object virtual functions definitions:*/
/*FUNCTION SpcDynamic::Echo {{{1*/
void SpcDynamic::Echo(void){

	printf("SpcDynamic:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	printf("   isset: %s\n",isset?"true":"false");
	printf("   analysis_type: %s\n",EnumToStringx(analysis_type));
	return;
}
/*}}}1*/
/*FUNCTION SpcDynamic::DeepEcho {{{1*/
void SpcDynamic::DeepEcho(void){

	this->Echo();
	return;
}		
/*}}}1*/
/*FUNCTION SpcDynamic::Id {{{1*/
int    SpcDynamic::Id(void){ return sid; }
/*}}}1*/
/*FUNCTION SpcDynamic::MyRank {{{1*/
int    SpcDynamic::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}1*/
/*FUNCTION SpcDynamic::ObjectEnum{{{1*/
int SpcDynamic::ObjectEnum(void){

	return SpcDynamicEnum;

}
/*}}}1*/
/*FUNCTION SpcDynamic::copy {{{1*/
Object* SpcDynamic::copy() {
	return new SpcDynamic(*this); 
}
/*}}}1*/

/*Constraint virtual functions definitions: */
/*FUNCTION SpcDynamic::InAnalysis{{{1*/
bool SpcDynamic::InAnalysis(int in_analysis_type){
	if (in_analysis_type==this->analysis_type) return true;
	else return false;
}
/*}}}*/
/*FUNCTION SpcDynamic::ConstrainNode{{{1*/
void SpcDynamic::ConstrainNode(Nodes* nodes,Parameters* parameters){

	Node* node=NULL;

	/*Chase through nodes and find the node to which this SpcDynamic applys: */
	node=(Node*)nodes->GetObjectById(NULL,nodeid);

	/*Apply constraint: */
	if(node){ //in case the spc is dealing with a node on another cpu

		/*We should first check that the value has been set... (test306)*/
		node->ApplyConstraint(dof,value);
	}
}
/*}}}*/

/*SpcDynamic functions*/
/*FUNCTION SpcDynamic::GetDof {{{1*/
int SpcDynamic::GetDof(){
	return dof;
}
/*}}}1*/
/*FUNCTION SpcDynamic::GetNodeId {{{1*/
int   SpcDynamic::GetNodeId(){
	
	return nodeid;
}
/*}}}1*/
/*FUNCTION SpcDynamic::GetValue {{{1*/
double SpcDynamic::GetValue(){
	_assert_(this->isset);
	_assert_(!isnan(value));
	return value;
}
/*}}}1*/
/*FUNCTION SpcDynamic::SetDynamicConstraint {{{1*/
void SpcDynamic::SetDynamicConstraint(Nodes* nodes,double* yg_serial){

	int pos;

	Node* node=(Node*)nodes->GetObjectById(NULL,nodeid);
	pos=node->GetDof(dof-1,GsetEnum);

	this->value=yg_serial[pos];
	this->isset=true;
}
/*}}}1*/
