/*!\file SpcStatic.c
 * \brief: implementation of the SpcStatic object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"
#include "../objects.h"

/*SpcStatic constructors and destructor*/
/*FUNCTION SpcStatic::SpcStatic(){{{1*/
SpcStatic::SpcStatic(){
	return;
}
/*}}}1*/
/*FUNCTION SpcStatic::SpcStatic(int spc_sid,int spc_nodeid,...){{{1*/
SpcStatic::SpcStatic(int spc_sid,int spc_nodeid, int spc_dof,double spc_value,int spc_analysis_type){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=spc_value;
	analysis_type=spc_analysis_type;

	return;
}
/*}}}1*/
/*FUNCTION SpcStatic::~SpcStatic{{{1*/
SpcStatic::~SpcStatic(){
	return;
}
/*}}}1*/
		
/*Object virtual functions definitions:*/
/*FUNCTION SpcStatic::Echo {{{1*/
void SpcStatic::Echo(void){

	printf("SpcStatic:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	printf("   analysis_type: %s\n",EnumToStringx(analysis_type));
	return;
}
/*}}}1*/
/*FUNCTION SpcStatic::DeepEcho {{{1*/
void SpcStatic::DeepEcho(void){

	printf("SpcStatic:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	printf("   analysis_type: %s\n",EnumToStringx(analysis_type));
	return;
}		
/*}}}1*/
/*FUNCTION SpcStatic::Id {{{1*/
int    SpcStatic::Id(void){ return sid; }
/*}}}1*/
/*FUNCTION SpcStatic::MyRank {{{1*/
int    SpcStatic::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}1*/
/*FUNCTION SpcStatic::ObjectEnum{{{1*/
int SpcStatic::ObjectEnum(void){

	return SpcStaticEnum;

}
/*}}}1*/
/*FUNCTION SpcStatic::copy {{{1*/
Object* SpcStatic::copy() {
	return new SpcStatic(*this); 
}
/*}}}1*/

/*Constraint virtual functions definitions: */
/*FUNCTION SpcStatic::InAnalysis{{{1*/
bool SpcStatic::InAnalysis(int in_analysis_type){
	if (in_analysis_type==this->analysis_type) return true;
	else return false;
}
/*}}}*/
/*FUNCTION SpcStatic::ConstrainNode{{{1*/
void SpcStatic::ConstrainNode(Nodes* nodes,Parameters* parameters){

	Node* node=NULL;

	/*Chase through nodes and find the node to which this SpcStatic applys: */
	node=(Node*)nodes->GetObjectById(NULL,nodeid);

	/*Apply constraint: */
	if(node){ //in case the spc is dealing with a node on another cpu
		node->ApplyConstraint(dof,value);
	}
}
/*}}}*/

/*SpcStatic functions*/
/*FUNCTION SpcStatic::GetDof {{{1*/
int SpcStatic::GetDof(){
	return dof;
}
/*}}}1*/
/*FUNCTION SpcStatic::GetNodeId {{{1*/
int   SpcStatic::GetNodeId(){
	
	return nodeid;
}
/*}}}1*/
/*FUNCTION SpcStatic::GetValue {{{1*/
double SpcStatic::GetValue(){
	_assert_(!isnan(value));
	return value;
}
/*}}}1*/
