/*!\file DoubleParam.c
 * \brief: implementation of the DoubleParam object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*DoubleParam constructors and destructor*/
/*FUNCTION DoubleParam::DoubleParam(){{{1*/
DoubleParam::DoubleParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleParam::DoubleParam(int enum_type,IssmDouble value){{{1*/
DoubleParam::DoubleParam(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleParam::~DoubleParam(){{{1*/
DoubleParam::~DoubleParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleParam::Echo {{{1*/
void DoubleParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleParam::DeepEcho{{{1*/
void DoubleParam::DeepEcho(void){

	printf("DoubleParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %g\n",this->value);
}
/*}}}*/
/*FUNCTION DoubleParam::Id{{{1*/
int    DoubleParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleParam::MyRank{{{1*/
int    DoubleParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleParam::ObjectEnum{{{1*/
int DoubleParam::ObjectEnum(void){

	return DoubleParamEnum;

}
/*}}}*/
/*FUNCTION DoubleParam::copy{{{1*/
Object* DoubleParam::copy() {
	
	return new DoubleParam(this->enum_type,this->value);

}
/*}}}*/

/*DoubleParam virtual functions definitions: */
/*FUNCTION DoubleParam::GetParameterName{{{1*/
void DoubleParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int* pinteger){{{1*/
void DoubleParam::GetParameterValue(int* pinteger){
	_error_("Double param of enum %i (%s) cannot return an integer",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(bool* pbool){{{1*/
void DoubleParam::GetParameterValue(bool* pbool){
	_error_("Double param of enum %i (%s) cannot return an bool",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM){{{1*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM){
	_error_("Double param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{1*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	_error_("Double param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(double** pdoublearray,int* pM){{{1*/
void DoubleParam::GetParameterValue(double** pdoublearray,int* pM){
	_error_("Double param of enum %i (%s) cannot return an array of double",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){{{1*/
void DoubleParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){
	_error_("Double param of enum %i (%s) cannot return an array of double",enum_type,EnumToStringx(enum_type));
}
/*}}}*/
/*FUNCTION DoubleParam::UnitConversion{{{1*/
void  DoubleParam::UnitConversion(int direction_enum){
	::UnitConversion(&this->value,1,direction_enum,this->enum_type);
}
/*}}}*/
