#module imports
from fielddisplay import fielddisplay

class flowequation:
	#properties
	def __init__(self):
		# {{{ Properties
		
		self.ismacayealpattyn     = 0;
		self.ishutter             = 0;
		self.isstokes             = 0;
		self.vertex_equation      = float('NaN')
		self.element_equation     = float('NaN')
		self.bordermacayeal       = float('NaN')
		self.borderpattyn         = float('NaN')
		self.borderstokes         = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   flow equation parameters:'

		string="%s\n\n%s"%(string,fielddisplay(obj,'ismacayealpattyn','is the macayeal or pattyn approximation used ?'))
		string="%s\n%s"%(string,fielddisplay(obj,'ishutter','is the shallow ice approximation used ?'))
		string="%s\n%s"%(string,fielddisplay(obj,'isstokes','are the Full-Stokes equations used ?'))
		string="%s\n%s"%(string,fielddisplay(obj,'vertex_equation','flow equation for each vertex'))
		string="%s\n%s"%(string,fielddisplay(obj,'element_equation','flow equation for each element'))
		string="%s\n%s"%(string,fielddisplay(obj,'bordermacayeal','vertices on MacAyeal''s border (for tiling)'))
		string="%s\n%s"%(string,fielddisplay(obj,'borderpattyn','vertices on Pattyn''s border (for tiling)'))
		string="%s\n%s"%(string,fielddisplay(obj,'borderstokes','vertices on Stokes'' border (for tiling)'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		return obj
	#}}}

