/*!\file MatlabVectorToVector.cpp
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <mex.h>
#include <stdio.h>
#include <string.h>
#include "./matlabio.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
	
/*}}}*/

Vector* MatlabVectorToVector(const mxArray* mxvector){

	int dummy;
	Vector* vector=NULL;

	/*allocate vector object: */
	vector=new Vector();

	#ifdef _HAVE_PETSC_
	MatlabVectorToPetscVector(&vector->vector,&dummy,mxvector);
	#else
	vector->vector=MatlabVectorToSeqVec(mxvector);
	#endif
	
	return vector;
}
