/*! \file BoolParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLPARAM_H_
#define _BOOLPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class BoolParam: public Param{

	public:
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmBool value;

		/*BoolParam constructors, destructors: {{{1*/
		BoolParam();
		BoolParam(int enum_type,IssmBool value);
		~BoolParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  GetParameterValue(bool* pbool){*pbool=value;}
		void  GetParameterValue(int* pinteger){_error_("Bool param of enum %i (%s) cannot return an integer",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM){_error_("Bool param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM,int* pN){_error_("Bool param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double* pdouble){_error_("Bool param of enum %i (%s) cannot return a double",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char** pstring){_error_("Bool param of enum %i (%s) cannot return a string",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){_error_("Bool param of enum %i (%s) cannot return a string array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){_error_("Bool param of enum %i (%s) cannot return a double array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){_error_("Bool param of enum %i (%s) cannot return a double array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){_error_("Bool param of enum %i (%s) cannot return a matrix array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Vector** pvec){_error_("Bool param of enum %i (%s) cannot return a Vec",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Matrix** pmat){_error_("Bool param of enum %i (%s) cannot return a Mat",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(FILE** pfid){_error_("Bool param of enum %i (%s) cannot return a FILE",enum_type,EnumToStringx(enum_type));}

		void  SetValue(bool boolean){this->value=boolean;}
		void  SetValue(int integer){this->value=(bool)integer;}
		void  SetValue(double scalar){this->value=(bool)scalar;}
		void  SetValue(char* string){_error_("Bool param of enum %i (%s) cannot hold a string",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char** stringarray,int M){_error_("Bool param of enum %i (%s) cannot hold a string array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* doublearray,int M){_error_("Bool param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){_error_("Bool param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* intarray,int M){_error_("Bool param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* pintarray,int M,int N){_error_("Bool param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Vector* vec){_error_("Bool param of enum %i (%s) cannot hold a Vec",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Matrix* mat){_error_("Bool param of enum %i (%s) cannot hold a Mat",enum_type,EnumToStringx(enum_type));}
		void  SetValue(FILE* fid){_error_("Bool param of enum %i (%s) cannot hold a FILE",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){_error_("Bool param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToStringx(enum_type));}
		void  UnitConversion(int direction_enum);
		
		void GetParameterName(char**pname);
		/*}}}*/
};
#endif  /* _BOOLPARAM_H */
