#module imports
from fielddisplay import fielddisplay

class settings:
	#properties
	def __init__(self):
		# {{{ Properties
		self.io_gather           = 0
		self.lowmem              = 0
		self.results_as_patches  = 0
		self.output_frequency    = 0
		self.waitonlock          = 0

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string="   general settings parameters:"

		string="%s\n%s"%(string,fielddisplay(obj,"io_gather","I/O gathering strategy for result outputs (default 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"lowmem","is the memory limited ? (0 or 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"results_as_patches","provide results as patches for each element (0 or 1)"))
		string="%s\n%s"%(string,fielddisplay(obj,"output_frequency","frequency at which results are saved in all solutions with multiple time_steps"))
		string="%s\n%s"%(string,fielddisplay(obj,"waitonlock","maximum number of minutes to wait for batch results, or return 0"))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#are we short in memory ? (0 faster but requires more memory)
		obj.lowmem=0

		#i/o:
		obj.io_gather=1

		#results frequency by default every step
		obj.output_frequency=1

		#do not use patches by default (difficult to plot)
		obj.results_as_patches=0

		#this option can be activated to load automatically the results
		#onto the model after a parallel run by waiting for the lock file
		#N minutes that is generated once the solution has converged
		#0 to desactivate
		obj.waitonlock=float('Inf')

		return obj
	#}}}

