/* \file WriteData.c:
 * \brief: general interface for writing data
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#define NO_IMPORT

#include "../../toolkits/toolkits.h"
#include "../../include/include.h"
#include "../../modules/modules.h"
#include "../../Container/Container.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"


/*FUNCTION WriteData(PyObject* py_tuple,int index,char* string){{{1*/
void WriteData(PyObject* py_tuple, int index, char* string){
	
	PyTuple_SetItem(py_tuple, index, PyUnicode_FromString(string));

}
/*}}}*/
/*FUNCTION WriteData(PyObject* tuple,int index,Matrix* matrix){{{1*/
void WriteData(PyObject* tuple,int index,Matrix* matrix){
	
	int M,N;
	double* buffer=NULL;
	npy_intp dims[2]={0,0};
	PyObject* array=NULL;
	
	buffer=matrix->ToSerial();
	matrix->GetSize(&M,&N);
	dims[0]=(npy_intp)M;
	dims[1]=(npy_intp)N;
	array=PyArray_SimpleNewFromData(2,dims,NPY_DOUBLE,buffer);
	
	PyTuple_SetItem(tuple, index, array);


}
/*FUNCTION WriteData(PyObject* py_tuple,int index,Vector* vector){{{1*/
void WriteData(PyObject* tuple,int index,Vector* vector){
	
	int M;
	double* buffer=NULL;
	npy_intp dim=10;
	PyObject* array=NULL;
	
	buffer=vector->ToMPISerial();
	vector->GetSize(&M);
	dim=(npy_intp)M;
	array=PyArray_SimpleNewFromData(1,&dim,NPY_DOUBLE,buffer);
	
	PyTuple_SetItem(tuple, index, array);


}
/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index, double* matrix, int M, int N){{{1*/
void WriteData(PyObject* tuple, int index, double* matrix, int M,int N){
	
	npy_intp dims[2]={0,0};
	PyObject* array=NULL;
	
	dims[0]=(npy_intp)M;
	dims[1]=(npy_intp)N;
	array=PyArray_SimpleNewFromData(2,dims,NPY_DOUBLE,matrix);
	
	PyTuple_SetItem(tuple, index, array);

}
