/*
 * \file Constraints.c
 * \brief: implementation of the Constraints class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Constraints::Constraints(){{{1*/
Constraints::Constraints(){
	enum_type=ConstraintsEnum;
	return;
}
/*}}}*/
/*FUNCTION Constraints::~Constraints(){{{1*/
Constraints::~Constraints(){
	return;
}
/*}}}*/

/*Numerics: */
/*FUNCTION Constraints::NumberOfConstraints{{{1*/
int Constraints::NumberOfConstraints(void){

	int localconstraints;
	int numberofconstraints;

	/*Get number of local constraints*/
	localconstraints=this->Size();

	/*figure out total number of constraints combining all the cpus (no clones here)*/
	#ifdef _HAVE_MPI_
		MPI_Reduce(&localconstraints,&numberofconstraints,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
		MPI_Bcast(&numberofconstraints,1,MPI_INT,0,MPI_COMM_WORLD);
	#else
		numberofconstraints=localconstraints;
	#endif
	

	return numberofconstraints;
}
/*}}}*/
