#module imports
from fielddisplay import fielddisplay

class steadystate:
	#properties
	def __init__(self):
		# {{{ Properties
		self.reltol            = 0
		self.maxiter           = 0
		self.requested_outputs = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   steadystate solution parameters:'
		string="%s\n%s"%(string,fielddisplay(obj,'reltol','relative tolerance criterion'))
		string="%s\n%s"%(string,fielddisplay(obj,'maxiter','maximum number of iterations'))
		string="%s\n%s"%(string,fielddisplay(obj,'requested_outputs','additional requested outputs'))
		return string
		#}}}
		
	def setdefaultparameters(obj):
		# {{{setdefaultparameters
		
		#maximum of steady state iterations
		obj.maxiter=100

		#Relative tolerance for the steadystate convertgence
		obj.reltol=0.01

		return obj
	#}}}

