#/bin/bash
#This script picks up whatever configuration files exists in trunk/configs, 
#and offers the user the choice to reconfigure the ISSM compilation using
#a given configuration file: 

#keep track of present directory: 
presendir=`pwd`

if test -d "$ISSM_DIR/configs" ; then
	cd $ISSM_DIR/configs
	LIST=`ls`
	
	if [[  $# == "0" ]]; then 
		COUNT=0;
		for STEP in $LIST
		do
			let COUNT=$COUNT+1
			printf '%3i: %s\n' $COUNT $STEP
		done

		echo -n "Configuration choice: "
		read choice 
	else
		choice=$1
	fi

	#Now go backto the list and retrieve the name of the configuration file: 
	COUNT=0;
	for STEP in $LIST
	do
		let COUNT=$COUNT+1
		if [[ $COUNT == $choice ]]; then
			configurename=$STEP
		fi
	done

	#Now go ahead and configure: 
	echo ""
	echo "Configuring ISSM with following configs: $configurename"
	echo ""

	cd $ISSM_DIR 
	source ./scripts/automakererun.sh 
	source configs/$configurename
	
	#we are done, go back to original directory: 
	cd $presendir
else
	echo "Configuration directory does not exist!"
	exit
fi






#alias aut='a=`pwd` && cd $ISSM_DIR && ./scripts/automakererun.sh && ./configs/config-macosx64-larour-nopetsc.sh'
