/*!\file SpcDynamic.h
 * \brief: header file for spc object
 */

#ifndef _SPCDynamic_H_
#define _SPCDynamic_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class SpcDynamic: public Constraint{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/
		bool isset;
		int analysis_type;

	public:

		/*SpcDynamic constructors, destructors:{{{1*/
		SpcDynamic();
		SpcDynamic(int sid,int nodeid, int dof,int analysis_type);
		~SpcDynamic();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Constraint virtual functions definitions: {{{1*/
		void   ConstrainNode(Nodes* nodes,Parameters* parameters);
		bool   InAnalysis(int analysis_type);
		/*}}}*/
		/*SpcDynamic management:{{{1 */
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		void   SetDynamicConstraint(Nodes* nodes,double *yg_serial);
		/*}}}*/

};

#endif  /* _SPCStatic_H_*/
