/* \file toolkits.h
 * \brief: this API allows use of external packages, provides patches, etc ...
 */

#ifndef _TOOLKITS_H_
#define _TOOLKITS_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _HAVE_PYTHON_
#include "./python/pythonincludes.h"
#endif

#ifdef _HAVE_PETSC_
#include "./petsc/petscincludes.h"
#endif

#ifdef _HAVE_MPI_
#include "./mpi/mpiincludes.h"
#endif

#ifdef _HAVE_METIS_
#include "./metis/metisincludes.h"
#endif

#include "./triangle/triangleincludes.h"
#include "./toolkitsenums.h"
#include "./issm/issmtoolkit.h"

#endif
