/*! \file DoubleMatExternalResult.h 
 */


#ifndef _DOUBLEMATEXTERNALRESULT_H_
#define _DOUBLEMATEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleMatExternalResult: public ExternalResult{

	private: 
		int id;
		int enum_type;
		double* values;
		int M;
		int N;
		int step;
		double time;

	public:
		/*DoubleMatExternalResult constructors, destructors: {{{1*/
		DoubleMatExternalResult();
		DoubleMatExternalResult(int id,int enum_type,double* values,int M,int N,int step, double time);
		~DoubleMatExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult managemnet: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _DOUBLEMATEXTERNALRESULT_H */
