/*!\file BoolParam.c
 * \brief: implementation of the BoolParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*BoolParam constructors and destructor*/
/*FUNCTION BoolParam::BoolParam(){{{1*/
BoolParam::BoolParam(){
	return;
}
/*}}}*/
/*FUNCTION BoolParam::BoolParam(int enum_type,IssmBool value){{{1*/
BoolParam::BoolParam(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolParam::~BoolParam(){{{1*/
BoolParam::~BoolParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolParam::Echo {{{1*/
void BoolParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolParam::DeepEcho{{{1*/
void BoolParam::DeepEcho(void){

	printf("BoolParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %s\n",this->value?"true":"false");
}
/*}}}*/
/*FUNCTION BoolParam::Id{{{1*/
int    BoolParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolParam::MyRank{{{1*/
int    BoolParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolParam::ObjectEnum{{{1*/
int BoolParam::ObjectEnum(void){

	return BoolParamEnum;

}
/*}}}*/
/*FUNCTION BoolParam::copy{{{1*/
Object* BoolParam::copy() {
	
	return new BoolParam(this->enum_type,this->value);

}
/*}}}*/

/*BoolParam virtual functions definitions: */
/*FUNCTION BoolParam::GetParameterName{{{1*/
void BoolParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION BoolParam::UnitConversion{{{1*/
void  BoolParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
