/* \file PetscMatrixToDoubleMatrix.cpp
 * \brief: convert a sparse or dense Petsc matrix into a matlab matrix
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string>

/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

/*Petsc includes: */
#include "../../../shared/shared.h"


void PetscMatrixToDoubleMatrix(double** pmatrix, int* prows, int* pcols,Mat petsc_matrix){

	int i,j,k;

	/*output: */
	double* matrix=NULL;
	int     rows,cols;

	/*intermediary: */
	int*    idxm=NULL;
	int*    idxn=NULL;

	/*Some needed information: */
	MatGetSize(petsc_matrix,&rows,&cols);

	idxm=(int*)xmalloc(rows*sizeof(int));
	idxn=(int*)xmalloc(cols*sizeof(int));

	for(i=0;i<rows;i++)idxm[i]=i;
	for(i=0;i<cols;i++)idxn[i]=i;

	matrix=(double*)xmalloc(rows*cols*sizeof(double));
	MatGetValues(petsc_matrix,rows,idxm,cols,idxn,matrix);

	/*Assign output pointers: */
	*pmatrix=matrix;
	*prows=rows;
	*pcols=cols;
}
