#!/bin/bash
#Step 1: unzip and install
#Step 2: After Plapack implodes
STEP=0

if [ $STEP -eq 1 ]; then
	#Some cleanup
	rm -rf install petsc-2.3.2-p3 src
	mkdir install src

	#Untar and move petsc to install directory
	tar -zxvf  petsc-2.3.2-p3.tar.gz
	mv petsc-2.3.2-p3/* install/
	rm -rf petsc-2.3.2-p3

	#configure
	cd install
	./config/configure.py \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--ISSM_ARCH=$ISSM_ARCH \
		--PETSC_DIR=$PETSC_DIR   \
		--with-debugging=no \
		--with-shared=0 COPTFLAGS=-O3 FOPTFLAGS=-O3 \
		--with-blas-lapack-dir=/opt/intel/mkl/9.1.023 \
		--with-mpi-lib=/usr/lib/libmpi.so \
		--with-mpi-include=/usr/include  \
		--with-mpi-shared=0 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-plapack=yes \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort

	echo "== Fix Plapack compilation manually (http://issm.jpl.nasa.gov/installation/compilationtroubleshooting/petsc232/) =="
	echo "== Then run STEP=2 =="
fi
if [ $STEP -eq 2 ]; then
	cd install
	./config/configure.py  \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--ISSM_ARCH=$ISSM_ARCH \
		--PETSC_DIR=$PETSC_DIR   \
		--with-debugging=no \
		--with-shared=0 COPTFLAGS=-O3 FOPTFLAGS=-O3 \
		--with-blas-lapack-dir=/opt/intel/mkl/9.1.023 \
		--with-mpi-lib=/usr/lib/libmpi.so \
		--with-mpi-include=/usr/include  \
		--with-mpi-shared=0 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--with-plapack-dir=$PETSC_DIR/externalpackages/PLAPACKR32-hg/$ISSM_ARCH \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort
	echo "== Follow PETSc's instructions"
fi
