/*!\file IntMatParam.c
 * \brief: implementation of the IntMatParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntMatParam constructors and destructor*/
/*FUNCTION IntMatParam::IntMatParam(){{{1*/
IntMatParam::IntMatParam(){
	return;
}
/*}}}*/
/*FUNCTION IntMatParam::IntMatParam(int enum_type,IssmIntMat value){{{1*/
IntMatParam::IntMatParam(int in_enum_type,int* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=(int*)xmalloc(M*N*sizeof(int));
	memcpy(value,in_value,M*N*sizeof(int));
}
/*}}}*/
/*FUNCTION IntMatParam::~IntMatParam(){{{1*/
IntMatParam::~IntMatParam(){
	xfree((void**)&value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntMatParam::Echo {{{1*/
void IntMatParam::Echo(void){

	printf("IntMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);

}
/*}}}*/
/*FUNCTION IntMatParam::DeepEcho{{{1*/
void IntMatParam::DeepEcho(void){

	int i,j;
	
	printf("IntMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			printf("(%i,%i) %i\n",i,j,*(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION IntMatParam::Id{{{1*/
int    IntMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntMatParam::MyRank{{{1*/
int    IntMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntMatParam::ObjectEnum{{{1*/
int IntMatParam::ObjectEnum(void){

	return IntMatParamEnum;

}
/*}}}*/
/*FUNCTION IntMatParam::copy{{{1*/
Object* IntMatParam::copy() {
	
	return new IntMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*IntMatParam virtual functions definitions: */
/*FUNCTION IntMatParam::GetParameterValue{{{1*/
void  IntMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	int* output=NULL;

	output=(int*)xmalloc((int)(M*N*sizeof(int)));
	memcpy(output,value,M*N*sizeof(int));

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntMatParam::GetParameterName{{{1*/
void IntMatParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntMatParam::SetValue{{{1*/
void  IntMatParam::SetValue(int* intarray,int in_M,int in_N){

	/*avoid leak: */
	xfree((void**)&this->value);

	this->value=(int*)xmalloc(in_M*in_N*sizeof(int));
	memcpy(this->value,intarray,in_M*in_N*sizeof(int));

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION IntMatParam::UnitConversion{{{1*/
void  IntMatParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
