/*!\file MaxVzx
 * \brief: compute misfit between observations and model
 */

#include "./MaxVzx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxVzx( double* pmaxvz, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	double maxvz;
	double node_maxvz;
	double element_maxvz;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVz(&element_maxvz,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxvz=element_maxvz; //initialize maxvz
		else{
			if(element_maxvz>maxvz)maxvz=element_maxvz;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvz=-INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxvz,&node_maxvz,1,MPI_DOUBLE,MPI_MAX,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxvz,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxvz=node_maxvz;
	#endif

	/*Assign output pointers:*/
	*pmaxvz=maxvz;
}
